/**************************************************************************************/
// jQuery Mobile 1.4 functions
// copyright 2021 NSB Corporation. All rights reserved.

var NSB = NSB || {}; // setup the NSB namespace, if needed

function IsNull(obj) {
    return obj == null;
}

$(document).on('mobileinit', function () {
    $.mobile.ignoreContentEnabled = true;
    });

NSB.Checkbox_jqm = function (id, width, options, style, properties, Theme, klass, corners, iconPos) {
    var i, s;
    var arrOptions = options.split(",");
    if (corners) corners = " data-corners=" + corners;
    s = "<fieldset data-role='controlgroup' id='" + id + "' " + properties + corners;
    s += " " + iconPos + " style='margin-top:0px;" + style + "' class='needsclick " + klass + "'>\n";
    for (i = 0; i < arrOptions.length; i++) {
        s = s + "  <input type='checkbox' data-theme=" + Theme + " name='" + id + "_" + (i + 1) + "' id='" + id + "_" + (i + 1) + "'>\n";
        s = s + "  <label for='" + id + "_" + (i + 1) + "'>" + arrOptions[i] + "</label>";
    }
    s = s + "</fieldset>";
    //console.log(s)
    return s;
};

NSB.Checkbox_jqm_init = function (id, options) {
    var arrOptions = options.split(",");
    NSB.$(id).style.zIndex = 0;
    for (var i = 0; i < arrOptions.length; i++) {
        window[id + '_' + (i + 1)] = document.getElementById(id + '_' + (i + 1));
    }
    NSB.addDisableProperty(NSB.$(id));
    //if(width<=10) NSB.$(id).style.width=document.width-18+"px";
    NSB.$(id).getValue = function (n) {
        try {
            return NSB.$(id + "_" + n).checked;
        } catch (err) {
            alert(err.message);
        }
    };
    NSB.$(id).setValue = function (n, val) {
        if (typeof (val) !== "boolean") {
            alert($.i18n(`Error: Must be true or false: ${id}[${n}] ${val}`));
        }
        try {
            NSB.$(id + "_" + n).checked = val;
            $('#' + id + '_' + n).checkboxradio('refresh');
        } catch (err) {
            alert(err.message);
        }
    };
};

NSB.RadioButton_jqm = function (id, width, items, value, style, properties, Theme, klass, corners, iconPos) {
    var i, s;
    var arrOptions = items.split(",");
    if (Theme !== "") Theme = "data-theme=" + Theme;
    if (corners) corners = " data-corners=" + corners + " ";
    if (iconPos === 'left') iconPos = "";
    s = "<fieldset data-role='controlgroup' id='" + id + "' " + properties + corners;
    s += iconPos + " style='margin-top:0px; "+style+"' class='" + klass + "'>\n";
    for (i = 0; i < arrOptions.length; i++) {
        s = s + "  <input type='radio' " + Theme + " name='" + id + "_group' id='" + id + "_" + (i + 1) + "'";
        if (i === value - 1) s = s + " checked=checked";
        s = s + " value='" + i + "'>\n";
        s = s + "  <label for='" + id + "_" + (i + 1) + "'>" + arrOptions[i] + "</label>\n";
    }
    s = s + "</fieldset>";
    //console.log(s);
    return s;
};

NSB.RadioButton_jqm_init = function (id, width) {
    NSB.addDisableProperty(NSB.$(id));
    NSB.$(id).style.height = "auto";
    NSB.$(id).style.zIndex = 0;
    if (width <= 10) NSB.$(id).style.width = document.body.clientWidth - 18 + "px";
    NSB.$(id).getItemCount = function () {
        return NSB.$(id).children[0].childElementCount;
    };
    NSB.$(id).getValue = function (n) {
        try {
            return NSB.$(id + "_" + n).checked;
        } catch (err) {
            alert(err.message);
        }
    };
    NSB.$(id).setValue = function (n, val) {
        if (typeof (val) !== "boolean") {
            alert($.i18n(`Error: Must be true or false: ${id}[${n}] ${val}`));
        }
        try {
            NSB.$(id + "_" + n).checked = val;
            $('#' + id + '_' + n).checkboxradio('refresh');
        } catch (err) {
            alert(err.message);
        }
    };
    NSB.$(id).value = function () {
        for (var i = 1; i <= NSB.$(id).getItemCount(); i++) {
            if (NSB.$(id).getValue(i)) return i;
        }
        return -1;
    };
    NSB.$(id).hide = function () {
        this.style.display = 'none';
    };
    NSB.$(id).show = function () {
        this.style.display = 'block';
    };
};

NSB.Select_jqm = function (id, items, values, placeholder, selectedIndex, name, style, disabled, icon, iconPos, inline, nativeMenu, overlayTheme, Theme, mini, group, multiSelect, align, klass, corners) {
    var i, s, arrItems, arrValues, v;
    arrItems = items.split(",");
    if (items === '') {
        arrItems = [];
    }
    arrValues = values.split(",");
    if (values === '') {
        arrValues = [];
    }
    s = "<style> #" + id + " .ui-select {margin:0px}</style>\n";
    if (align !== '') {
        s = s + "<style> #" + id + " .ui-btn {text-align:" + align + "}</style>\n";
    }
    s += "<select id=" + id + "_inner";
    s += " data-icon=" + icon;
    s += " data-iconpos=" + iconPos;
    s += " data-inline=" + inline;
    s += " data-native-menu=" + nativeMenu;
    s += " data-corners=" + corners;
    s += " data-shadow=false";
    s += " " + mini;
    if (multiSelect === "true") {
        s += " multiple=multiple";
    }
    if (overlayTheme !== '') s += " data-overlay-theme=" + overlayTheme;
    if (Theme !== '') s += " data-theme=" + Theme;
    if (disabled !== '') s += disabled;
    if (icon === "custom") s += " ui-nodisc-icon";
    s += ">\n";
    for (i = 0; i < arrItems.length; i++) {
        if ((i < arrValues.length) && (arrValues[i] !== ""))
            v = arrValues[i];
        else
            v = i + 1;
        s += "  <option value='" + (v) + "'";
        if (i + 1 === placeholder) s += " data-placeholder=true";
        if (i + 1 === selectedIndex) s += " selected=selected";
        s += ">" + arrItems[i] + "</option>\n";
    }
    s += "</select>";
    switch (group) {
    case "":
        {
            if (NSB.selectGroup === "" || typeof (NSB.selectGroup) === 'undefined') {
                var s1 = "<div id=" + id;
                if (klass !== '') s1 += " class='" + klass + "'";
                if (style !== '') s1 += " style='" + style + "'";
                s = s1 + ">\n" + s + "\n</div>";
                //console.log("ungrouped:\n" + s)
                return s;
            } else
                NSB.selectGroup += '\n<div id=' + id + " class='" + klass + "'></div>\n" + s;
            //console.log("middle:\n" + NSB.selectGroup);
            break;
        }
    case "vertical":
        {
            NSB.selectGroup = '<div data-role=fieldcontain id=' + id + " style='margin:0px;' class='" + klass + "'>\n<fieldset data-role=controlgroup>\n" + s;
            //console.log("vertical:\n" + NSB.selectGroup);
            break;
        }
    case "horizontal":
        {
            NSB.selectGroup = '<div data-role="fieldcontain" id=' + id + " style='margin:0px;' class='" + klass + "'>\n<fieldset data-role='controlgroup' data-type='horizontal'>\n" + s;
            //console.log("horizontal:\n" + NSB.selectGroup);
            break;
        }
    case "end":
        {
            NSB.selectGroup += "\n<div id=" + id + " class='" + klass + "'></div>\n" + s + "\n</fieldset></div>";
            //console.log(NSB.selectGroup);
            s = NSB.selectGroup;
            NSB.selectGroup = "";
            return s;
        }
    }
};

NSB.Select_jqm_init = function (el, html, group, shadow, icon) {
        if (group === "end") NSB.selectGroup = "";
        if (html.indexOf('ui-disabled') > 0) {
            setTimeout("$(NSB.$('" + el.id + "_inner')).selectmenu('disable')", 10);
        }
        NSB.addDisableProperty(el);
        NSB.addProperties(el);
        if (shadow === false) $("#"+el.id+"_inner-button").removeClass('ui-shadow');
        if (icon === 'custom') $("#"+el.id).closest("div").addClass("ui-nodisc-icon");
        el.getItemCount = function () {
            return NSB.$(el.id + '_inner').length;
        };
        el.selectedIndex = function () {
            var s = [];
            for (var i = 0; i < el.getItemCount(); i++) {
                if (NSB.$(el.id + '_inner')[i].selected === true) {
                    s.push(i);
                }
            }
            if (NSB.$(el.id + '_inner').multiple === false) {
                return s[0];
            } else {
                return s;
            }
        };
        el.selectedValue = function () {
            var s = el.selectedIndex();
            if (s === null) return s;
            if (typeof(s) === 'undefined') return s;
            if (typeof (s) === "number") {
                s = [s];
            }
            for (var i = 0; i < s.length; i++) {
                s[i] = NSB.$(el.id + "_inner")[s[i]].value;
            }
            if (NSB.$(el.id + "_inner").multiple === false) {
                return s[0];
            } else {
                return s;
            }
        };
        el.selectedItem = function () {
            var s = el.selectedIndex();
            if (s === null) return s;
            if (typeof(s) === 'undefined') return s;
            if (typeof (s) === "number") {
                s = [s];
            }
            for (var i = 0; i < s.length; i++) {
                s[i] = NSB.$(el.id + "_inner")[s[i]].text;
            }
            if (NSB.$(el.id + "_inner").multiple === false) {
                return s[0];
            } else {
                return s;
            }
        };
        el.setIndex = function (n) {
            if (Number.isInteger(n) == false) {
                console.log("Error: " + el.id + ".setIndex called with Nan");
                return
                }
            var i;
            if (typeof(n) == 'number') n = [n];
            for (var i = 0; i < el.getItemCount(); i++) {
                $('#' + el.id + '_inner :nth-child(' + (i+1) + ')').prop('selected', false);
            }
            for (i = 0; i < n.length; i++) {
                $('#' + el.id + '_inner :nth-child(' + (n[i]+1) + ')').prop('selected', true);
                }
            $('#' + el.id + '_inner').selectmenu("refresh");
        };
        el.clear = function () {
            NSB.$(el.id + "_inner").options.length = 0;
        };
        el.addItem = function (arrItems, name) {
            var item, itemValue, i, mySelect;
            if(typeof(arrItems) !== "object") 
                arrItems = [{item: arrItems, itemValue: name}];
            else if (arrItems.item !== undefined)
                arrItems = [arrItems];
             for (i = 0; i < arrItems.length; i++) {
                if(typeof(arrItems[i]) === 'object') {
                    item = arrItems[i].item;
                    itemValue = arrItems[i].itemValue;
                } else {
                    item = arrItems[i];
                    itemValue = undefined;
                }
                mySelect = NSB.$(el.id + "_inner");
                if (typeof (itemValue) === "undefined") itemValue = mySelect.length;
                mySelect.options[mySelect.length] = new Option(item, itemValue);
                }
            $(mySelect).selectmenu("refresh");        
        };
        el.getValue = function (n) {
            return NSB.$(el.id + "_inner").options[n].selected;
        };
        el.getItem = function (n) {
            return NSB.$(el.id + "_inner")[n].text;
        };
        el.List = function (n) {
            return el.getItem(n);
        };
        NSB.defineProperty(el, 'text', {
            get: function () {
                return el.selectedItem();
            }
        });
        NSB.defineProperty(el, 'ListCount', {
            get: function () {
                return el.getItemCount();
            }
        });
        NSB.defineProperty(el, 'ListIndex', {
            get: function () {
                return el.selectedIndex();
            },
            set: function (n) {
                el.setIndex(n);
                if (typeof (el.onclick) === 'function') {
                    el.onclick();
                }
                if (typeof (el.onchange) === 'function') {
                    el.onchange();
                }
            }
        });
    }; //end select_jqm_init

NSB.ToolTip_jqm = function (id, popupmsg, datatransition, theme, message, style, icon, klass) {
    if (theme !== '') theme = " data-theme=" + theme;
    var s = "<a id=" + id + " href='#" + id + "_popupInfo' style='margin:0px;' data-rel='popup' data-role='button' ";
    s += "class='" + klass + " ui-icon-alt";
    if (icon === "custom") s += " ui-nodisc-icon";
    s += "' data-inline='true' data-transition='" + datatransition;
    s += "' data-icon=" + icon + theme + " data-iconpos='notext' title='" + message + "'>" + message + "</a>\n";
    s += "<div data-role='popup' id='" + id + "_popupInfo' class='ui-content'" + theme + " style='" + style + "'>\n";
    s += popupmsg + "</div>";
    //console.log(s);
    return s;
};

NSB.HeaderBar_jqm14 = function (id, title, leftButtonName, leftButtonIcon, leftButtonIconPos, rightButtonName, rightButtonIcon, rightButtonIconPos, html, corners, buttonTheme) {
    var name;
    var s = "<div id='" + id + "' data-role='header'" + html + ">\n";
    if (leftButtonIcon === "false" || leftButtonIcon === "none") leftButtonIconPos = "none";
    if (leftButtonName !== "" || leftButtonIconPos !== "none") {
        name = (leftButtonName === "") ? leftButtonIcon : leftButtonName;
        if (leftButtonIconPos === "notext") leftButtonName = "";
        s += "  <div id='" + id + "_left' class='ui-btn ui-btn-left" + corners;
        if (leftButtonIconPos !== "none") s += " ui-btn-icon-left ui-icon-" + leftButtonIcon;
        if (leftButtonIcon === "custom") s += " ui-nodisc-icon";
        if (buttonTheme !== "") s += " ui-btn-" + buttonTheme;
        s += "' data-iconpos=" + leftButtonIconPos;
        s += " nsbclick='" + id + "' nsbvalue='" + name + "'";
        s += " style='height:14px;'>" + leftButtonName + "\n  </div>\n";
    }
    if (title !== "") s += "  <h1>" + title + "</h1>\n";

    if (rightButtonIcon === "false" || rightButtonIcon === "none") rightButtonIconPos = "none";
    if (rightButtonName !== "" || rightButtonIconPos !== "none") {
        name = (rightButtonName === "") ? rightButtonIcon : rightButtonName;
        if (rightButtonIconPos === "notext") rightButtonName = "";
        s += "  <div id='" + id + "_right' class='ui-btn ui-btn-right" + corners;
        if (rightButtonIconPos !== "none") s += " ui-btn-icon-right ui-icon-" + rightButtonIcon;
        if (rightButtonIcon === "custom") s += " ui-nodisc-icon";
        if (buttonTheme !== "") s += " ui-btn-" + buttonTheme;
        s += "' data-iconpos=" + rightButtonIconPos;
        s += " nsbclick='" + id + "' nsbvalue='" + name + "'";
        s += " style='height:14px;'>" + rightButtonName + "\n  </div>\n";
    }
    s += "</div>\n";
    //console.log(s);
    return s;
};

NSB.FooterBar_jqm14 = function (id, items, theme, icons, iconPos, active, klass, style) {
    var i, s;
    var arrItems = items.split(",");
    var arrIcons = icons.split(",");
    s = "<div id=" + id + " data-role='footer' class='" + klass + "' style='" + style + "' data-theme=" + theme + " data-position='fixed'>\n";
    s += "<div data-role=navbar data-iconpos=" + iconPos + ">\n";
    s += "<ul>\n";
    for (i = 0; i < arrItems.length; i++) {
        arrItems[i] = arrItems[i].trim();
        if (arrIcons[i]) arrIcons[i] = arrIcons[i].trim();
        s += "  <li>\n";
        s += "    <a id='" + (id + "_" + i) + "' nsbclick='" + id + "' nsbvalue='" + arrItems[i].replace(new RegExp(' ', 'g'), "_") + "' href='#'";
        if (theme !== "") s += " data-theme=" + theme + "";
        if ((i < arrIcons.length) && (arrIcons[i] !== "")) s += " data-icon=" + arrIcons[i];
        if (arrIcons[i] === "custom") s += " class='ui-nodisc-icon'";
        if (i + 1 === active) s += " class='ui-btn-active'";
        s += ">\n";
        s += "    " + arrItems[i] + "\n";
        s += "    </a>\n";
    }
    s += "</ul></div></div>\n";
    //console.log(s);
    return s;
};

NSB.FooterBar_jqm_init = function (id, items) {
    var arrItems = items.split(",");
    for (var i = 0; i < arrItems.length; i++) {
        NSB.$(id + "_" + i).onclick = function () {
            NSB.$(this.getAttribute("nsbclick")).onclick(this.getAttribute("nsbvalue"));
        };
    }
    NSB.addDisableProperty(NSB.$(id));
    NSB.$(id).style.width = "100%";
    NSB.$(id).style.left = "0px";
    NSB.$(id).style.height = "auto";
    NSB.$(id).style.top = "auto";
    NSB.$(id).style.bottom = "0px";
    NSB.$(id).refresh();
};

NSB.NavBar_jqm14 = function (id, items, theme, icons, iconPos, active, klass, style) {
    var i, s;
    var arrItems = items.split(",");
    var arrIcons = icons.split(",");
    if (theme !== "") theme = " data-theme=theme";
    s = "<div id=" + id + " data-role=navbar data-iconpos=" + iconPos + " class='" + klass + "' style='" + style + "'>\n";
    s += "<ul>\n";
    for (i = 0; i < arrItems.length; i++) {
        arrItems[i] = arrItems[i].trim();
        s += "  <li>\n";
        s += "    <a id='" + (id + "_" + i) + "' nsbclick='" + id + "' nsbvalue='" + arrItems[i].replace(new RegExp(' ', 'g'), "_") + "' href='#'" + theme + " ";
        if ((i < arrIcons.length) && (arrIcons[i] !== "")) s += " data-icon=" + arrIcons[i].trim();
        if (arrIcons[i] === "custom") s += " class='ui-nodisc-icon'";
        if (i + 1 === active) s += " class='ui-btn-active'";
        s += ">\n";
        s += "    " + arrItems[i] + "\n";
        s += "    </a>\n";
    }
    s += "</ul></div>\n";
    //console.log(s);
    return s;
};

NSB.NavBar_jqm_init = function (id, items) {
    var arrItems = items.split(",");
    for (var i = 0; i < arrItems.length; i++) {
        NSB.$(id + "_" + i).onclick = function () {
            NSB.$(this.getAttribute("nsbclick")).onclick(this.getAttribute("nsbvalue"));
        };
    }
    NSB.addDisableProperty(NSB.$(id));
    NSB.$(id).style.width = "100%";
    NSB.$(id).style.left = "0px";
    NSB.$(id).style.height = "auto";
};

NSB.PopUp_jqm14 = function (id, items, text, datatransition, theme, dataTheme, mini, corners, icon, iconPos, popup, style, klass) {
    var i, s, arrItems, menu;
    arrItems = items.split(",");
    if (items === '') {
        arrItems = [];
    }
    menu = id + "Menu";
    s = "<a id=" + id + " href='#" + menu + "' data-rel='popup' data-transition='" + datatransition + "' style='" + style + " margin-top:0px' ";
    s += "class='" + klass + " ui-btn ui-btn-inline " + mini + " " + corners;
    if (theme !== "") s += " ui-btn-" + theme + "";
    if (icon !== '') s += " ui-icon-" + icon + " ui-btn-icon-" + iconPos;
    if (icon === "customer") s += " ui-nodisc-icon";
    s += "'>" + text + "</a>\n";
    s += "<div data-role='popup' id='" + menu + "' data-theme='" + dataTheme + "'>\n";
    if (items !== "") {
        s += "<ul data-role='listview' data-inset='true' style='min-width:210px;'>\n";
        s += "  <li data-role='divider'>" + popup + "</li>\n";
        for (i = 0; i < arrItems.length; i++) {
            s += "  <li id='" + (id + "_" + i) + "' nsbclick='" + id + "' nsbvalue='" + arrItems[i] + "'>" + arrItems[i] + "</li>\n";
        }
        s += "</ul></div>";
    } else {
        s += "<p>" + popup + "</div>";
    }
    //console.log(s);
    return s;
};

NSB.PopUp_jqm_init = function (el, items) {
    if (items === '') return;
    var arrItems = items.split(",");
    for (var i = 0; i < arrItems.length; i++) {
        NSB.$(el.id + "_" + i).onclick = function () {
            NSB.$(this.getAttribute("nsbclick")).onclick(this.getAttribute("nsbvalue"));
        };
    }
    el.close = function () {
        $("#" + el.id + "Menu").popup("close");
    };
};

NSB.List_jqm14 = function (id, showNumbers, imageStyle, dataTheme, dividerTheme, itemList, imageList, dividerList, style, properties, width, scrolling, readonly, corners, icon, filter, filterPlaceholder, filterReveal, autoDividers, hidden) {
    var i, s = '';
    if (dataTheme !== '') dataTheme = " data-theme=" + dataTheme;
    if (style !== '') style = " style='" + style + "'";
    if (dividerTheme !== '') dividerTheme = " data-divider-theme=" + dividerTheme;
    filterPlaceholder = ((filterPlaceholder !== '') && (filter === 'true')) ? filterPlaceholder = " data-filter-placeholder='" + filterPlaceholder + "'" : "";
    filter = (filter === 'true') ? " data-filter=true" : '';
    filterReveal = (filterReveal === 'true') ? " data-filter-reveal=true" : '';
    autoDividers = (autoDividers === 'true') ? " data-autodividers=true" : '';
    if (scrolling) s = "<div id='" + id + "_scroller'>\n";
    s += "<div id='" + id + "' style='" + hidden + "'>\n";
    s += "<" + showNumbers + " id=" + id + "_list data-role='listview' class='ui-listview";
    if (icon === "custom") s += " ui-nodisc-icon";
    s += "' data-corners='" + corners + "' data-icon=" + icon;
    s += filter + filterReveal + filterPlaceholder + autoDividers;
    s += " data-inset=true" + dataTheme + dividerTheme + " nsb-imageStyle='" + imageStyle + "'" + style + ">";
    var arrItems = itemList.split(",");
    var arrImages = imageList.split(",");
    var arrDividers = dividerList.split(",");
    for (i = 0; i < arrItems.length; i++) {
        s += "\n  <li";
        if ((i < arrDividers.length) && (arrDividers[i] === "Y")) {
            s += " id='" + (id + "_" + i) + "' data-role='list-divider' role='heading' style='white-space:normal;'>";
        } else {
            if (!readonly) {
                s += ">";
                s += "<a id='" + (id + "_" + i) + "' nsbclick='" + id + "' nsbvalue='" + i + "' href='#' style='white-space:normal;'>";
            } else s += ">";
        }
        if ((i < arrImages.length) && (arrImages[i] !== "") && (imageStyle !== '')) {
            s += "<img src='" + arrImages[i] + "' class='" + imageStyle + "'>";
        }
        s += arrItems[i].trim();
        if (!((i < arrDividers.length) && (arrDividers[i] === "Y"))) {
            s += readonly ? "" : "</a>";
        }
    }
    s += "\n</" + showNumbers + ">";
    s += "\n</div>\n";
    if (scrolling) s += "</div>\n";
    // console.log(s);
    return s;
};

NSB.List_jqm_init14 = function (id, items, scrolling, width, readonly, filterReveal) {
    NSB.$(id).scroller = NSB.$(id+'_scroller');
    NSB.$(id).ref = NSB.$(id+'_ref');
    NSB.$(id).list = NSB.$(id+'_list');
    if (items.trim() !== '') {
        var arrItems = items.trim().split(",");
        for (var i = 0; i < arrItems.length; i++) {
            if (!readonly && NSB.$(id + "_" + i).nodeName !== 'LI')
                NSB.$(id + "_" + i).onclick = function () {
                    NSB.$(this.getAttribute("nsbclick")).onclick(this.getAttribute("nsbvalue"));
                };
        }
    }
    NSB.addDisableProperty(NSB.$(id));
    if (scrolling) {
        NSB.$(id + "_scroller").style.width = Number.isInteger(width) ? width + "px" : width;
        NSB.$(id).style.width = "100%";
    } else NSB.$(id).style.width = Number.isInteger(width) ? width + "px" : width;
    NSB.$(id).readonly = readonly;
    NSB.$(id).getItemCount = function () {
        var elem = NSB.$(id);
        return elem.getElementsByTagName("li").length;
    };
    NSB.$(id).getItem = function (i) {
        return $('#' + this.id + "_" + i).text();
    };
    NSB.$(id).deleteItem = function (which) {
        var elem = NSB.$(id + '_list');
        if (IsNull(which)) {
            which = NSB.$(id).getItemCount() - 1;
            elem.removeChild(elem.getElementsByTagName("li")[which]);
        } else if (which.toUpperCase() === "ALL") {
            $('#' + id + '_list').empty();
        }
        NSB.$(id).refresh();
    };
    NSB.$(id).addItem = function (itemName, imgSrc, itemNo, divider, theme) {
        var s, i, newLi;
        if (IsNull(itemNo)) {
            i = NSB.$(id).getItemCount();
        } else {
            i = itemNo;
        }
        if (typeof (itemName) !== "string") itemName = itemName.toString();
        newLi = document.createElement("li");
        if (divider !== true) {
            if (!this.readonly) {
                if (theme) newLi.setAttribute("data-theme", theme);
                if (filterReveal) newLi.setAttribute("class", "ui-screen-hidden");
                s = "<a id='" + (id + "_" + i) + "' href='#' nsbclick='" + id + "' nsbvalue='" + i + "'>";
                if (imgSrc) s += " <img src='" + imgSrc + "' class='" + NSB.$(id + '_list').getAttribute("nsb-imageStyle") + "'>";
                s += itemName.trim() + "</a>\n";
                newLi.innerHTML += s;
                //console.log(s);
                setTimeout(id+'_'+i + ".onclick = function() {" + id + ".onclick(" + i + ")}",100);
            } else {
                newLi.innerHTML += itemName;
            }
        } else {
            newLi.setAttribute("data-role", "list-divider");
            newLi.innerHTML = itemName;
        }
        if (IsNull(itemNo)) {
            NSB.$(id + '_list').appendChild(newLi);
        } else {
            NSB.$(id + '_list').insertBefore(newLi, NSB.$(id + '_list').getElementsByTagName("li")[itemNo]);
        }
        NSB.$(id).refresh();
        var padding = NSBPage.style.paddingBottom;
        $(NSB.$(id + '_list')).listview("refresh");
        NSBPage.style.paddingBottom = padding;
    };
    NSB.$(id).replaceItem = function (itmNo, newItemName, newImgSrc) {
        if ((isNaN(itmNo)) || (itmNo < 0 || itmNo > NSB.$(id).getItemCount() - 1)) {
            return -1;
        }
        var elem = NSB.$(id + '_list');
        elem.removeChild(elem.getElementsByTagName("li")[itmNo]);
        NSB.$(id).addItem(newItemName, newImgSrc, itmNo);
        return itmNo;
    };
    NSB.$(id).setFilter = function (str) {
        $('input[data-type="search"]').val(str);
        $('input[data-type="search"]').trigger("keyup");
    };
};

NSB.Panel_jqm14 = function (id, display, dataTheme, theme, animate, dismissible, position, positionFixed, text, style, klass) {
    // <div data-role="panel" id="leftpanel2" data-position="left" data-display="push" data-theme="a">
    var s = "<div data-role='panel' ";
    s += " id='" + id + "' href='" + id + "' ";
    s += " style='" + style + "'";
    s += " class='" + klass + "'";
    s += " theme='" + theme + "'";
    s += " data-animate='" + animate + "'";
    s += " data-dismissible='" + dismissible + "'";
    s += " data-position='" + position + "'";
    s += " data-position-fixed='" + positionFixed + "'";
    s += " data-theme='" + dataTheme + "'";
    s += " data-display='" + display + "'> ";
    s += "<div class='panel-content'>";
    s += text;
    s += " </div></div>";
    //console.log(s);
    return s;
};

NSB.Panel_jqm_init14 = function(id) {
    NSB.$(id).open = function(form) {
        $(this).panel('open');
        if (typeof form === 'object') {
            this.appendChild(form);
            form.show();
            form.resize(0, 0, this.Width, this.Height);
            form.previousForm = NSB.currentForm;
            NSB.currentForm = form;
            if (NSB.enableBrowserArrows) location.hash = '#/' + NSB.currentForm.id;
            form.panel = true;
            if (typeof form.onshow === 'function')
                form.onshow();
        }
        if (typeof form === 'string') this.innerHTML = form;
    };
    NSB.$(id).onpanelbeforeclose = function() {
        if (typeof NSB.currentForm.onhide === 'function') {
            NSB.currentForm.onhide();
        }
        if (NSB.currentForm.previousForm !== undefined) {
            NSB.currentForm.panel = false;
            NSB.currentForm.hide();
            NSB.currentForm = NSB.currentForm.previousForm;
            NSB.currentForm.refresh();
        }
    };
    NSB.$(id).close = function() {
        $(this).panel('close');
    };
};